//
// $Header: /var/mnt/Data/CVS_REPO/Clients/Marketcircle/Frameworks/MCApplication/MCTableView.h,v 1.37 2007/11/05 21:34:08 alalani Exp $

#import <AppKit/AppKit.h>

#import "MCTableColumnHelperProtocol.h"
// This provides a 'plus' button in the cornerView.  Clicking on the plus button allows the user to add columns.  Additionally, columns may be selected and removed from the display  by hitting the delete key.

extern NSString *MCTableViewColumnsDidChangeNotification;

@class MCTableColumnHelper;

typedef enum _MCTableViewGradientStyle {
    MCTableViewGradientStyleNone	  = 0, // don't draw gradient, let NSTableView handle it
    MCTableViewGradientStyleAll	      = 1, // image for focus, not focus  
	MCTableViewGradientStyleFocusOnly = 2 // only use image for focus, not focus send to super
} MCTableViewGradientStyle;

@interface MCTableView : NSTableView <MCTableColumnHelperProtocol>
{
	NSColor		*rowColor;
	NSColor		*alternateColor;

	NSMenu      *columnMenu;
	
	unsigned int   _externalDraggingMask;

	// Editing begins after a double-click delay after one click on an already selected row/column, just like in finder and itunes
	BOOL delayedEditMode;
	int delayedEditColumn;
	int delayedEditRow;
	NSEvent *delayedEditEvent;
	
	NSMutableDictionary *regionList;
	
	SEL deleteAction; // if delete is pressed, what should be called?
	SEL canDeleteAction;
	
	// New TableColumn management (mclark - May 12 2005)
	MCTableColumnHelper   *_tableColumnHelper;
	NSString*              _columnAutoSaveName;
	NSMutableDictionary*   _columnConfig;
	NSString*              _columnGroupIdentifier;
	NSString*              _columnSubGroupIdentifier;
	NSMutableArray*        _activeColumns;
	NSMutableArray*        _inactiveColumns;

	BOOL canShowViewOptions;

	MCTableViewGradientStyle gradientStyle;
	
	id inlineSearchDelegate;
	NSMutableString *inlineSearchString;
	NSTimer *__inlineSearchTimer;
	NSString *_lastKeyDownCharacter;

	NSArray *rejectMouseEventColumns;

	id contextualMenuDelegate; // we ask him for contextual menu items

}

- (IBAction)showViewOptions:(id)sender;

- (NSMenu *)columnMenu;
- (void)setColumnMenu:(NSMenu *)aMenu;

- (NSColor *)rowColor;
- (void)setRowColor:(NSColor *)aColor;

- (NSColor *)alternateRowColor;
- (void)setAlternateRowColor:(NSColor *)aColor;

- (BOOL)delayedEditMode;
- (void)setDelayedEditMode:(BOOL)flag;

- (NSEvent *)delayedEditEvent;
- (void)setDelayedEditEvent:(NSEvent *)aDelayedEditEvent;

// gets called after a delayed to start up an edit if delayedEditMode is YES
- (void)delayedEdit;

// Use these methods to override the draggingSourceOperationForLocal: behaviour of NSTableView
// You cannot set this behaviour on a non subclassed tableview for some dumb reason, now you can!
- (unsigned int)externalDraggingMask;
- (void)setExternalDraggingMask:(unsigned int)anExternalDraggingMask;

- (void)awakeFromNib;
- (NSString *)_mcKeyForColumn:(int)columnIndex row:(int)rowIndex;

- (void)setEnabled:(BOOL)flag;

// New TableColumn management (mclark - May 12 2005)
- (MCTableColumnHelper *)tableColumnHelper;
- (void)setTableColumnHelper:(MCTableColumnHelper *)aTableColumnHelper;

- (NSString *)columnAutoSaveName;
- (void)setColumnAutoSaveName:(NSString *)aColumnAutoSaveName;
- (NSMutableDictionary *)columnConfig;
- (void)setColumnConfig:(NSMutableDictionary *)aColumnConfig;
- (NSString *)columnGroupIdentifier;
- (void)setColumnGroupIdentifier:(NSString *)aColumnGroupIdentifier;
- (NSString *)columnSubGroupIdentifier;
- (void)setColumnSubGroupIdentifier:(NSString *)aColumnSubGroupIdentifier;


- (NSMutableArray *)activeColumns;
- (void)setActiveColumns:(NSMutableArray *)anActiveColumns;
- (NSMutableArray *)inactiveColumns;
- (void)setInactiveColumns:(NSMutableArray *)anInactiveColumns;

- (BOOL)canShowViewOptions;
- (void)setCanShowViewOptions:(BOOL)flag;

- (SEL)deleteAction;
- (void)setDeleteAction:(SEL)aDeleteAction;
- (SEL)canDeleteAction;
- (void)setCanDeleteAction:(SEL)aCanDeleteAction;

- (id)inlineSearchDelegate;
- (void)setInlineSearchDelegate:(id)anInlineSearchDelegate;

- (NSMutableString *)inlineSearchString;
- (void)setInlineSearchString:(NSMutableString *)anInlineSearchString;

- (NSString *)lastKeyDownCharacter;
- (void)setLastKeyDownCharacter:(NSString *)aLastKeyDownCharacter;

- (id)contextualMenuDelegate;
- (void)setContextualMenuDelegate:(id)aContextualMenuDelegate;

- (MCTableViewGradientStyle)gradientStyle;
- (void)setGradientStyle:(MCTableViewGradientStyle)aGradientStyle;

@end

@interface NSObject (MCTableViewDelegate)
- (BOOL)tableView:(NSTableView *)tv 
	shouldAllowActivationOfColumn:(NSTableColumn *)column;
	
- (void)tableView:(NSTableView *)tv cornerViewItemDidAct:(id)aMenuItem;

- (void)tableViewDidChangeColumns:(NSTableView *)tv;


- (BOOL)tableViewCanCopyTabularDataToPasteboard:(NSTableView *)tv;
- (BOOL)tableViewCanExportTabularData:(NSTableView *)tv;

	//	This subclass of NSTableView allows you to display different tool tips
	//	for each cell in the table.
	//
	//	When the table view needs to display a tool tip, it asks it's data source
	//	for it. So you need to implement tableView:toolTipForTableColumn:row: in
	//	your table's data source. See declaration below.
- (NSString *)tableView:(NSTableView *)aTableView toolTipForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;

- (void)tableviewBecameFirstResponder: (MCTableView*)tableview;

@end

// TEMP: added by mclark to aid in maintaining columns sizes when removing
@interface NSTableColumn (MCAdditions)

- (void)addWidthToNumber: (NSNumber *)number;

@end

@interface NSObject (MCTableInlineSearchDelegate)
- (int)rowForSearchString:(NSString *)str;
@end

@interface NSTableView (PrivateMethods)
+ (NSImage *)_defaultTableHeaderSortImage;
+ (NSImage *)_defaultTableHeaderReverseSortImage;
@end

@interface NSTableView (ShutUpCompiler)
- (id)_highlightColorForCell:(NSCell *)cell;
@end

